<?php

namespace App\Controllers;


class Home extends BaseController
{
	public function index()
	{
		

		$session = \Config\Services::session();
		
		if($session->get('fullName')==null){
			
			if(!empty($this->request->getPost('correo')) && !empty($this->request->getPost('clave'))){
				$correo = $this->request->getPost('correo');
				$clave = $this->request->getPost('clave');
			}else{
				$session->setFlashdata('mensaje_malo', 'Ingrese usuario y clave, por favor');
				return redirect()->to(base_url()); 
			}

			$respuesta=$this->loginmegaprofer($correo,$clave);
			
			if(!empty($respuesta)){
				$session->set($respuesta);
				$data = array(
                'username' => $correo,
                'ADMIN_is_logged_in' => true
                );
				$session->sess_expiration = '7200';// expires in 4 hours
                //$session->set_userdata($data);// set session
				$resultado_estadisticas = $this->estadisticas();
				$enviar_datos=array(
					'estadisticas'=>!empty($resultado_estadisticas['data'])?$resultado_estadisticas['data']:null
				);
				echo view("layouts/header");
				echo view("layouts/aside");
				echo view("dashboard");//$enviar_datos);
				echo view("layouts/footer");
			}else{
				$session->setFlashdata('mensaje_malo', 'Usuario y/o contraseña erróneos');
				return redirect()->to(base_url()); 
			}

			
			$resultado_login = $this->login($correo,$clave);

			if(!empty($resultado_login)){
				if($resultado_login['code']==200){					
					$session->set($resultado_login['data'][0]);		
					$resultado_estadisticas = $this->estadisticas();
					$enviar_datos=array(
						'estadisticas'=>!empty($resultado_estadisticas['data'])?$resultado_estadisticas['data']:null
					);
					echo view("layouts/header");
					echo view("layouts/aside");
					echo view("dashboard",$enviar_datos);
					echo view("layouts/footer"); 
				}else{
					$session->setFlashdata('mensaje_malo', 'Usuario y/o contraseña erróneos');
					return redirect()->to(base_url()); 
				}
			}else{
				$session->setFlashdata('mensaje_malo', 'Falla en la conección.');
				return redirect()->to(base_url()); 
			}
		}else{		
			$resultado_estadisticas = $this->estadisticas();
			
			$enviar_datos=array(
				'estadisticas'=>!empty($resultado_estadisticas['data'])?$resultado_estadisticas['data']:null
			);	
			echo view("layouts/header");
			echo view("layouts/aside");
			echo view("dashboard", $enviar_datos);
			echo view("layouts/footer"); 
		}
	}

	public function login($correo,$clave){
		$datos_post = http_build_query(
			array(
				"usu_correo"=> $correo,
				"usu_clave"=> $clave,
			)
		);
		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);
		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'login', false, $contexto);
		$resultado=json_decode($resultado,true);
		if(!empty($resultado)){
			return $resultado;
		}else{
			return null;
		}
	}

	public function estadisticas(){
		
		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/x-www-form-urlencoded',
			)
		);
		$contexto = stream_context_create($opciones);
		$resultado = file_get_contents($this->url_api_conciliacion.'estadisticasrelacionpagosventasayervshoy', false, $contexto);
		$resultado=json_decode($resultado,true);
		if(!empty($resultado)){
			return $resultado;
		}else{
			return null;
		}
	}

	public function loginmegaprofer($username,$password){
		
		$datos_post = array(
			"username"=> $username,
			"password"=> $password,
		);
		
		$opciones = array('http' =>
			array(
				'method'  => 'POST',
				'header'  => 'Content-type: application/json',
				'ignore_errors' => true,
				'content' => json_encode($datos_post)
			)
		);

		$contexto = stream_context_create($opciones);
		

		//$resultado = file_get_contents('https://int.api.megaprofer.com/back/login', false, $contexto);    API PRUEBA
		$resultado = file_get_contents('https://api.megaprofer.com/back/login', false, $contexto);
		$resultado=json_decode($resultado,true);
		if(!empty($resultado)){
			return $resultado;
		}else{
			return null;
		}
	}

	public function logout(){
		$session = \Config\Services::session();	
		$session->stop();
		$session->destroy();
		$session=null;		
		return redirect()->to(base_url()); 
		
	}
	
	public function actualizarBancos(){
	    $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded'
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'megaproferbanco', false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            $session->setFlashdata('mensaje_bueno', $resultado);
            return redirect()->to(base_url('Home'));
        }else{
            return null;
        }
        
	}
}

