<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard de Ventas</title>
   
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .card {
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
        }
        .table thead th {
            text-align: center;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header text-white text-center" style="background-color: inherit;">
                        <h2 class="mb-0">Dashboard de Ventas</h2>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <div class="card p-3">
                                    <h4 class="text-center">Ventas por Mes</h4>
                                    <canvas id="ventasMesChart"></canvas>
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="card p-3">
                                    <h4 class="text-center">Ventas por Producto</h4>
                                    <canvas id="ventasProductosChart"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card p-3">
                                    <h4 class="text-center">Ventas de Productos por Mes</h4>
                                    <canvas id="ventasProductosMesChart"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card p-3">
                                    <h4 class="text-center">Fórmulas Vendidas por Mes</h4>
                                    <div class="table-responsive">
                                        <table class="table table-striped table-bordered text-center">
                                            <thead class="table-dark">
                                                <tr>
                                                    <th>Mes</th>
                                                    <th>Total de Fórmulas Vendidas</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($formulas_por_mes as $formula): ?>
                                                    <tr>
                                                        <td>Mes <?= $formula['mes'] ?></td>
                                                        <td><?= $formula['total_formulas'] ?></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        var ventasMesData = {
            labels: [<?php foreach ($ventas_mes as $v) { echo "'Mes ".$v['mes']."',"; } ?>],
            datasets: [{
                label: 'Ventas Totales',
                data: [<?php foreach ($ventas_mes as $v) { echo $v['total_ventas'].","; } ?>],
                backgroundColor: 'rgba(54, 162, 235, 0.5)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        };

        var ventasProductosData = {
            labels: [<?php foreach ($ventas_productos as $v) { echo "'".$v['Pro_Nombre']."',"; } ?>],
            datasets: [{
                label: 'Cantidad Vendida',
                data: [<?php foreach ($ventas_productos as $v) { echo $v['total_vendido'].","; } ?>],
                backgroundColor: 'rgba(255, 99, 132, 0.5)',
                borderColor: 'rgba(255, 99, 132, 1)',
                borderWidth: 1
            }]
        };

        var ventasProductosMesLabels = [];
        var ventasProductosMesDatasets = {};
        <?php foreach ($ventas_productos_mes as $v) { ?>
            if (!ventasProductosMesLabels.includes('Mes ' + <?= $v['mes'] ?>)) {
                ventasProductosMesLabels.push('Mes ' + <?= $v['mes'] ?>);
            }
            if (!ventasProductosMesDatasets['<?= $v['Pro_Nombre'] ?>']) {
                ventasProductosMesDatasets['<?= $v['Pro_Nombre'] ?>'] = [];
            }
            ventasProductosMesDatasets['<?= $v['Pro_Nombre'] ?>'].push(<?= $v['total_vendido'] ?>);
        <?php } ?>
        
        var ventasProductosMesData = {
            labels: ventasProductosMesLabels,
            datasets: Object.keys(ventasProductosMesDatasets).map(function(nombre) {
                return {
                    label: nombre,
                    data: ventasProductosMesDatasets[nombre],
                    borderWidth: 1
                };
            })
        };

        new Chart(document.getElementById('ventasMesChart'), { type: 'bar', data: ventasMesData });
        new Chart(document.getElementById('ventasProductosChart'), { type: 'bar', data: ventasProductosData });
        new Chart(document.getElementById('ventasProductosMesChart'), { type: 'line', data: ventasProductosMesData });
    </script>
</body>
</html>
