<!-- application/Views/inventario_dashboard_tarjetas.php -->
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard de Inventario - Sistema HiPP</title>
    <link rel="stylesheet" href="<?= base_url('assets/css/bootstrap.min.css') ?>">
    <style>
        :root {
            --hipp-magenta: #e4007f;
            --hipp-green: #83b22c;
            --hipp-yellow: #f7d23b;
            --hipp-blue: #29a6da;
            --hipp-orange: #f36c3d;
            --hipp-white: #ffffff;
        }
        body {
            background-color: var(--hipp-white);
            color: #333;
            font-family: Arial, sans-serif;
        }
        .card {
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            padding: 15px;
        }
        .bg-magenta { background-color: var(--hipp-magenta); color: var(--hipp-white); }
        .bg-green { background-color: var(--hipp-green); color: var(--hipp-white); }
        .bg-yellow { background-color: var(--hipp-yellow); color: #000; }
        .bg-blue { background-color: var(--hipp-blue); color: var(--hipp-white); }
        .bg-orange { background-color: var(--hipp-orange); color: var(--hipp-white); }
        .card-title {
            font-size: 1.2rem;
            font-weight: bold;
        }
        .card-content {
            font-size: 1.5rem;
            font-weight: bold;
        }
        .critical {
            color: red;
            font-weight: bold;
        }
        .adequate {
            color: green;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center" style="color: var(--hipp-magenta);">Dashboard de Inventario</h1>
        <div class="row mt-4">
            <?php foreach ($inventario as $producto): ?>
                <div class="col-md-3">
                    <div class="card <?= $producto['Inv_Cantidad'] < $producto['Pro_StockMinimo'] ? 'bg-magenta' : 'bg-blue' ?>">
                        <h5 class="card-title"><?= $producto['Pro_Nombre'] ?></h5>
                        <div class="card-content">
                            Stock: <?= $producto['Inv_Cantidad'] ?>
                        </div>
                        <p>Stock Mínimo: <?= $producto['Pro_StockMinimo'] ?></p>
                        <p>
                            Estado: 
                            <?php if ($producto['Inv_Cantidad'] < $producto['Pro_StockMinimo']): ?>
                                <span class="critical">Crítico</span>
                            <?php else: ?>
                                <span class="adequate">Adecuado</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <script src="<?= base_url('assets/js/bootstrap.bundle.min.js') ?>"></script>
</body>
</html>
