<?php

namespace App\Models;

use CodeIgniter\Model;

class InventarioModel extends Model
{
    protected $db;

    public function __construct()
    {
        $this->db = \Config\Database::connect();
    }

    public function getInventarioDetallado()
    {
        return $this->db->table('Productos p')
            ->select('p.Pro_Id, p.Pro_Nombre, p.Pro_Descripcion, 
                      COALESCE(SUM(r.Rec_Cantidad), 0) AS Recibido, 
                      COALESCE(i.Inv_Cantidad, 0) AS StockActual, 
                      (COALESCE(SUM(r.Rec_Cantidad), 0) + COALESCE(i.Inv_Cantidad, 0)) AS InventarioReal,
                      p.Pro_StockMinimo,i.*')
            ->join('Inventario i', 'p.Pro_Id = i.Pro_Id', 'left') // LEFT JOIN para incluir productos sin inventario
            ->join('RecepcionProductos r', 'p.Pro_Id = r.Pro_Id', 'left') // LEFT JOIN para productos sin recepción
            ->groupBy('p.Pro_Id, p.Pro_Nombre, p.Pro_Descripcion, i.Inv_Cantidad, p.Pro_StockMinimo')
            ->get()
            ->getResultArray();
    }

}
