<?php
namespace App\Models;
use CodeIgniter\Model;
class CiudadesModel extends Model {
   protected $table = 'Ciudades';
    protected $primaryKey = 'Ciu_Id'; // Cambia esto según el nombre de tu clave primaria
    protected $allowedFields = [
        'Ciu_Ciudad'
        // Añade otros campos permitidos aquí
    ];

    public function getCiudades() {
        $this->db->order_by('Ciu_Ciudad', 'ASC');
        $query = $this->db->get('Ciudades');
        return $query->result_array();
    }


    public function getCiudad($id) {
        $query = $this->db->get_where('Ciudades', array('Ciu_Id' => $id));
        return $query->row_array();
    }

    public function insertCiudad($data) {
        return $this->db->insert('Ciudades', $data);
    }

    public function updateCiudad($id, $data) {
        $this->db->where('Ciu_Id', $id);
        return $this->db->update('Ciudades', $data);
    }

    public function deleteCiudad($id) {
        $this->db->where('Ciu_Id', $id);
        return $this->db->delete('Ciudades');
    }
}
?>
