<?php
namespace App\Controllers;
use CodeIgniter\RESTful\ResourceController;
use App\Models\VentasModel;
use App\Models\ClientesModel;
use App\Models\ProductosModel;
use App\Models\TipoPagoExternoModel;
use App\Models\VentasDetalleModel;
use App\Models\KardexInventarioModel;
use CodeIgniter\Controller;

class Ventas extends BaseController {

    public function __construct() {
        $this->ventasModel = new VentasModel();
        $this->ventasDetalleModel = new VentasDetalleModel();
        $this->productosModel = new ProductosModel();
        $this->clientesModel = new clientesModel();
        $this->kardexModel = new KardexInventarioModel();
        $this->TipoPagoExternoModel=new TipoPagoExternoModel();
    }

    public function index() {
        $data['ventas'] = $this->ventasModel->getVentasConDetalles();
        $data['clientes'] = $this->clientesModel->getClientesWithCiudades();
        $data['tipopagoe'] = $this->TipoPagoExternoModel->getAll();
        $data['productos'] = $this->productosModel->findAll();
    
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("ventas/list", $data);
        echo view("layouts/footer");
        echo view("ventas/scripts");
    }

    public function view($id) {
        $data['ventas'] = $this->ventasModel->get_ventas($id);
        if (empty($data['ventas'])) {
            show_404();
        }
        $this->load->view('productos/view', $data);
    }

    public function create()
{
    helper('form');

    if ($this->request->getMethod() === 'post' && $this->validate([
        'fecha' => 'required',
        'cliente' => 'required|integer',
    ])) {
        // Insertar cabecera de la venta
        
        $cabeceraData = [
            'Cli_Id' => $this->request->getPost('cliente'),
            'Ven_FechaVenta' => $this->request->getPost('fecha'),
            'Ven_ValorTotal' => $this->request->getPost('vtotalgeneral'),
            'Ven_TotalPagoCliente' => $this->request->getPost('vtotalgeneralpago'),
            'Ven_Descuento' => $this->request->getPost('vdescuento'),
            'Ven_ValorEnvioNacional' => $this->request->getPost('vnacional'),
            'Ven_NumeroFactura' => $this->request->getPost('numeroorden'),
            'Tpe_Id' => $this->request->getPost('tipopago'),
            'Ven_EnvioGratis' => $this->request->getPost('envioGratis') ? 1 : 0,
            'Ven_RegaloInfluencer' => $this->request->getPost('esRegalo') ? 1 : 0,
        ];

        // Intenta insertar la cabecera de la venta
        $insertResult = $this->ventasModel->create($cabeceraData);
        if (!$insertResult) {
            // Manejo de error de insercin
            return redirect()->back()->with('error', 'Error al registrar la cabecera de la venta.');
        }
        
        $ventaId = $this->ventasModel->insertID();
        
        // Insertar detalle de la venta
        $detalles = json_decode($this->request->getPost('detalleVenta'), true);
        
        $cantTotal=0;
        foreach ($detalles as $detalle) {
            $cantTotal+=$detalle['cantidad'];
        }
        $diferencia=($this->request->getPost('vtotalgeneralpago')-$this->request->getPost('vtotalgeneral')-$this->request->getPost('vnacional'));
        if($diferencia<0){
            $diferencia=$diferencia*-1;
            $diferencia=$diferencia/$cantTotal;
            $diferencia=$diferencia*-1;
        }
        else{
            $diferencia=$diferencia/$cantTotal;
        }
  
        $cont = 1;
        foreach ($detalles as $detalle) {
            $valorReal=$detalle['vunitario']+$diferencia;
            $detalleData = [
                'Ven_Id' => $ventaId,
                'Ved_Cantidad' => $detalle['cantidad'],
                'Ved_ValorUnitario' => $detalle['vunitario'],
                'Ved_ValorUnitario_Real' => $valorReal,
                'Ved_ValorTotal' => $detalle['vtotal'],
                'Ved_Descuento' => $detalle['descuento'],
                'Ved_Observacion' => $this->request->getPost('vtotalgeneralpago').' '.$this->request->getPost('vtotalgeneral').' '.$this->request->getPost('vinternacional').' '.$cantTotal,
                'Pro_Id' => $detalle['id']
            ];
            
            if ($cont == 1) {
                $detalle['venvio'] = $this->request->getPost('vinternacional');
                $cont++;
            } else {
                $detalle['venvio'] = 0;
            }
            $detalle['vtotalgeneral'] = $this->request->getPost('vtotalgeneral');

            // Verifica si el detalle se inserta correctamente
            if (!$this->ventasDetalleModel->insert($detalleData)) {
                return redirect()->back()->with('error', 'Error al registrar un detalle de la venta.');
            }

            // Actualizar el Kardex
            try {
                $this->actualizarKardex($detalle, $ventaId);
            } catch (\Exception $e) {
                return redirect()->back()->with('error', 'Error al actualizar el Kardex: ' . $e->getMessage());
            }
        }

        return redirect()->to('/ventas')->with('success', 'Venta registrada exitosamente.');
    }

    return redirect()->back()->with('error', 'Error al registrar la venta. Verifica los datos ingresados.');
}


    private function actualizarKardex($detalle, $ventaId)
    {
        $proId = $detalle['id'];
        $cantidad = $detalle['cantidad'];
        $precioUnitario = $detalle['vunitario'];
        $valorTotal = $detalle['vtotal'];
        $valorEnvio = $detalle['venvio'];
        $valorTotalGeneral=$detalle['vtotalgeneral'];
        // Obtener inventario actual
        $inventarioActual = $this->kardexModel
            ->where('Pro_Id', $proId)
            ->orderBy('Kar_FechaTransaccion', 'DESC')
            ->first();

        $saldoRestante = $inventarioActual
            ? $inventarioActual['Kar_SaldoRestante'] - $cantidad // Resta para egreso
            : 0; // Saldo no puede ser negativo

        // Insertar movimiento en el Kardex
        $kardexData = [
            'Pro_Id' => $proId,
            'Kar_TipoTransaccion' => 'Egreso', // Venta
            'Kar_Cantidad' => $cantidad,
            'Kar_PrecioUnitario' => 0,
            'Kar_ValorTotal' => 0,
            'Kar_FechaTransaccion' => date('Y-m-d H:i:s'),
            'Usu_Id' => session()->get('user_id'), // Usuario autenticado
            'Cod_Id' => $ventaId, // Relación con la venta
            'Kar_SaldoRestante' => $saldoRestante,
            'Kar_ValorTransaccion' => $valorTotal,
            'Kar_ValorEnvio' => 0,
            'Kar_PrecioVentaProducto' => $precioUnitario,
            'Pre_Id' => 0,
        ];

        if (!$this->kardexModel->insert($kardexData)) {
            throw new \Exception('Error al registrar movimiento en el Kardex.');
        }

        // Actualizar inventario
        $db = \Config\Database::connect();
        $inventarioTable = $db->table('Inventario');

        $inventario = $inventarioTable->where('Pro_Id', $proId)->get()->getRow();
        if ($inventario) {
            $nuevaCantidad = $inventario->Inv_Cantidad - $cantidad;
            $inventarioTable->where('Pro_Id', $proId)->update([
                'Inv_Cantidad' => $nuevaCantidad,
                'Inv_Actualizado' => date('Y-m-d H:i:s'),
            ]);
        }
    }



}
?>
