<?php
namespace App\Controllers;
use CodeIgniter\RESTful\ResourceController;
use App\Models\ComprasModel;
use App\Models\ProveedoresModel;
use App\Models\ProductosModel;
use App\Models\TipoPagoInternacionalModel;
use App\Models\ComprasDetalleModel;
use App\Models\KardexInventarioModel;
use CodeIgniter\Controller;

class Compras extends BaseController {

    public function __construct() {
        $this->comprasModel = new ComprasModel();
        $this->proveedoresModel = new ProveedoresModel();
        $this->tipoPagoInternacionalModel = new TipoPagoInternacionalModel();
        $this->productosModel = new ProductosModel();
        $this->comprasDetalleModel = new \App\Models\ComprasDetalleModel();
        $this->kardexModel = new KardexInventarioModel();
    }

    public function index() {
        $data['compras'] = $this->comprasModel->get_all_compras();
        $data['proveedores'] = $this->proveedoresModel->findAll();
        $data['tipopagoi'] = $this->tipoPagoInternacionalModel->findAll();
        $data['productos'] = $this->productosModel->findAll();
    
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("compras/list", $data);
        echo view("layouts/footer");
        echo view("compras/scripts");
    }

    public function view($id) {
        $data['compras'] = $this->comprasModel->get_compras($id);
        if (empty($data['compras'])) {
            show_404();
        }
        $this->load->view('productos/view', $data);
    }

    public function create()
    {
        helper('form');
    
        if ($this->request->getMethod() === 'post' && $this->validate(['fecha' => 'required'])) {
            // Insertar cabecera de compra
            $saveData = [
                'Prv_Id' => $this->request->getPost('proveedor'),
                'Com_FechaCompra' => $this->request->getPost('fecha'),
                'Com_ValorTotal' => $this->request->getPost('vtotal'),
                'Com_ValorEnvioNacional' => $this->request->getPost('vnacional'),
                'Com_ValorEnvioInternacional' => $this->request->getPost('vinternacional'),
                'Com_NumeroPedido' => $this->request->getPost('numeroorden'),
                'Tpi_Id' => $this->request->getPost('tipopago'),
            ];

            $this->comprasModel->insert($saveData);
            $compraId = $this->comprasModel->insertID();

            // Insertar detalle de compra
            $detalles = json_decode($this->request->getPost('detalleCompra'), true);
            $d = [];
            foreach ($detalles as $detalle) {
                $detalleData = [
                    'Com_Id' => $compraId,
                    'Cod_Cantidad' => $detalle['cantidad'],
                    'Com_ValorUnitario' => $detalle['vunitario'],
                    'Com_ValorTotal' => $detalle['vtotal'],
                    'Pro_Id' => $detalle['id'],
                ];

                $this->comprasDetalleModel->insert($detalleData);
                $detalle['Cod_Id'] = $this->comprasDetalleModel->insertID();
                array_push($d, $detalle);
            }

            // Registrar movimientos en el Kardex
            $this->registrarMovimiento($compraId, $d);

            return redirect()->to('/compras')->with('success', 'Compra guardada exitosamente.');
        }

        return redirect()->back()->with('error', 'Error al guardar la compra.');
    }




    public function edit()
    {
        $id = $this->request->getPost('editid');
        $data['productos'] = $this->comprasModel->find($id);
    
        if (empty($data['productos'])) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Producto no encontrado: ' . $id);
        }
    
        helper('form');
    
        if ($this->request->getMethod() === 'post' && $this->validate([
            'editnombre' => 'required',
        ])) {
            $this->comprasModel->update($id, [
                'Pro_Nombre' => $this->request->getPost('editnombre'),
                'Pro_Descripcion' => $this->request->getPost('editdescripcion'),
                'Pro_PrecioCompra' => $this->request->getPost('editcompra'),
                'Pro_PrecioVenta' => $this->request->getPost('editventa'),
                'Pro_StockMinimo' => $this->request->getPost('editstockminimo'),
            ]);
            return redirect()->to('/productos');
        } else {
            echo view('productos/edit', $data); // Asegúrate de que la vista se llama correctamente
        }
    }

    public function delete($id) {
        $this->comprasModel->delete_product($id);
        redirect('compras');
    }
    
    public function registrarMovimiento($compraId, $detalles)
    {
        foreach ($detalles as $detalle) {
            $proId = $detalle['id'];
            $cantidad = $detalle['cantidad'];
            $precioUnitario = $detalle['vunitario'];
            $valorTotal = $detalle['vtotal'];

            // Calcular el saldo restante
            $inventarioActual = $this->kardexModel
                ->where('Pro_Id', $proId)
                ->orderBy('Kar_FechaTransaccion', 'DESC')
                ->first();
            $saldoRestante = $inventarioActual
                ? $inventarioActual['Kar_SaldoRestante'] + $cantidad
                : $cantidad;

            // Datos para el Kardex
            $kardexData = [
                'Pro_Id' => $proId,
                'Kar_TipoTransaccion' => 'Ingreso',
                'Kar_Cantidad' => $cantidad,
                'Kar_PrecioUnitario' => $precioUnitario,
                'Kar_ValorTotal' => $valorTotal,
                'Kar_FechaTransaccion' => date('Y-m-d H:i:s'),
                'Usu_Id' => session()->get('user_id'),
                'Cod_Id' => $detalle['Cod_Id'],
                'Kar_SaldoRestante' => $saldoRestante,
                'Kar_ValorTransaccion' => $valorTotal,
                'Kar_ValorEnvio' => 0,
                'Kar_PrecioVentaProducto' => 0,
                'Pre_Id' => 0,
            ];

            // Insertar en el Kardex
            $result = $this->kardexModel->registrarMovimiento($kardexData);
            if (isset($result['error'])) {
                return redirect()->back()->with('error', 'Error en el Kardex: ' . implode(', ', $result['error']));
            }

            // Actualizar inventario
            
        }
    
    }
    public function registrarRecepcion()
{
    helper('form');

    if ($this->request->getMethod() === 'post' && $this->validate([
        'compra_id' => 'required|integer',
        'producto' => 'required|integer',
        'cantidad' => 'required|integer|min_length[1]',
    ])) {
        $recepcionModel = new \App\Models\RecepcionProductosModel();

        $data = [
            'Com_Id' => $this->request->getPost('compra_id'),
            'Pro_Id' => $this->request->getPost('producto'),
            'Rec_Cantidad' => $this->request->getPost('cantidad'),
            'Rec_Fecha' => $this->request->getPost('fecha'),
        ];

        if ($recepcionModel->insert($data)) {
            // Opcional: Aquí puedes verificar si todos los productos de la compra ya han llegado
            // y actualizar el Kardex si es necesario.
            $this->kardexModel->actualizarInventario($this->request->getPost('producto'), $this->request->getPost('cantidad'));
            return redirect()->to('/compras')->with('message', 'Recepción registrada correctamente.');
        } else {
            return redirect()->to('/compras')->with('error', 'Error al registrar la recepción.');
        }
    }
    else{
        echo "error"; die();
    }

    return redirect()->to('/compras')->with('error', 'Datos inválidos.');
}



}
?>
